<?php
defined('PF_VERSION') OR exit('Access denied');
class Pf {
	static protected $object = array();
	
	static public function database(){
		if (isset(self::$object['database'])){
			return self::$object['database'];
		}
		
		require ABSPATH . '/includes/zebra/database/Zebra_Database.php';
		self::$object['database'] = new Zebra_Database();
		if (is_ajax()){
			self::$object['database']->debug = false;
		}else{
			self::$object['database']->debug = DEBUG;
		}
		self::$object['database']->connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
		self::$object['database']->set_charset(DB_CHARSET,DB_COLLATE);
		
		return self::$object['database'];
	}
	static public function auth(){
        if (isset(self::$object['auth'])){
            return self::$object['auth'];
        }
        self::$object['auth'] = new Auth();
        return self::$object['auth'];
    }
	static public function validator(){
		if (isset(self::$object['validator'])){
			return self::$object['validator'];
		}
		
		require ABSPATH . '/includes/gump/gump.class.php';
		self::$object['validator'] = new GUMP();
		
		return self::$object['validator'];
	}
	
	static public function shortcode(){
		if (isset(self::$object['shortcode'])){
			return self::$object['shortcode'];
		}
		
		require ABSPATH . '/includes/shortcode-class.php';
		self::$object['shortcode'] = new Pf_Shortcode();
		
		return self::$object['shortcode'];
	}
	
	static public function setting(){
	    if (isset(self::$object['setting'])){
	        return self::$object['setting'];
	    }
	    
	    require ABSPATH . '/includes/setting-class.php';
	    self::$object['setting'] = new Pf_Setting();
	    
	    return self::$object['setting'];
	}
	
	static public function language(){
		if (isset(self::$object['language'])){
			return self::$object['language'];
		}
		
		require ABSPATH . '/includes/language-class.php';
		self::$object['language'] = new Pf_Language();
		
		return self::$object['language'];
	}
	
	static public function email_template(){
	    if (isset(self::$object['email_template'])){
	        return self::$object['email_template'];
	    }
	    
	    require ABSPATH . '/includes/email-template-class.php';
	    self::$object['email_template'] = new Pf_Email_Template();
	    
	    return self::$object['email_template'];
	}
	
	static public function security(){
	    if (isset(self::$object['security'])){
	        return self::$object['security'];
	    }
	    require ABSPATH . '/includes/security-class.php';
	    self::$object['security'] = new Pf_Security();
	     
	    return self::$object['security'];
	}
	
	static public function cookie(){
	    if (isset(self::$object['cookie'])){
	        return self::$object['cookie'];
	    }
	    
	    require ABSPATH . '/includes/cookie-class.php';
	    self::$object['cookie'] = new Pf_Cookie();
	    
	    return self::$object['cookie'];
	}
}